#pragma once
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#include "ClasesGenericas.h"
#include <AT2D3D/AT2D3D.h>

typedef struct _Valores_Interna{
	double f;
	double x;
	double y;
} Valores_Interna;

//Abreviaturas: Drs: Distorsión radial simétrica; Dts: Distorsión tangencial simétrica.
#define CAL_MODPOL_IMPAR 1
#define CAL_MODPOL_COMPLETO 2
#define CAL_MODASIM_RADTAN 1	//radial/tangencial
#define CAL_MODASIM_VECTOR 2	//vector giratorio
//
#define CAL_CONDICIONR_ORTO 0	//que la distorsión radial sea ortogonal a la focal. a1=0
#define CAL_CONDICIONR_R1 1		//ajustar a1 para que Drs(r1)=0
#define CAL_CONDICIONR_MM 2	//ajustar a1 para que |Drs mín|=|Drs máx|

/*Si el modelo de distorsiones asimétricas es radial/tangencial, la serie 1 son las componentes cos(k·theta)
y la serie 2 las componentes sin(k·theta). Si el modelo es el vector giratorio, la serie 1 son las componentes
(1-k)theta y la serie 2 las componentes (1+k)theta.
*/

typedef struct _Config_distorsion{
	float semidiag;		//Semidiagonal del fotograma, e.d., r_max. Si para una (auto)calibración se pasa INF o NAN el programa deduce su valor
	uint8m modelo_poli;		//modelo polínomico. Un 0 indica que no hay distorsión
	uint8m modelo_asim;		//modelo de distorsiones asimétricas. Un 0 indica que no hay distorsiones asimétricas
	uint8m condicion_radsim;	//condición para la definición del término lineal de la Drs (a1). V. supra
	float r1;			//si condicion_radsim es CAL_CONDICIONR_R1, el valor para el que se quiere Drs(r1)=0
	uint param_radsim;	//flags que indican los parámetros que se calculan de la Drs. a1, a2, a3... empezando en el bit más bajo.
	uint param_tansim;	//Idem para la distorsión tangencial simétrica
	uint param_asim1;		//Idem para la primera serie de componentes asimétricas.
	uint param_asim2;		//Idem para la primera serie de componentes asimétricas.
} Config_distorsion;

typedef struct _Distorsion{
	Config_distorsion config;
	float* valores_radsim;	//Los valores de las componentes que no existan
	float* valores_tansim;	//han de estar a cero no obstante la existencia de config
	float* valores_asim1;
	float* valores_asim2;
} Distorsion;

#define CAL_FLAG_Transf1	1U
#define CAL_FLAG_pp			2U		//(pp_x,pp_y)!=(0,0)
#define CAL_FLAG_Distorsiones 4U
#define CAL_FLAG_RadSim	8U
#define CAL_FLAG_TanSim	16U
#define CAL_FLAG_Asim1	32U
#define CAL_FLAG_Asim2	64U
#define CAL_FLAG_Asimetricas (64|32U)
#define CAL_FLAG_DistorsionesTodas (120U)
#define CAL_FLAGS_HayRadSim(f) (((f)&12U)==12U)
//info:  key	  val
#define CAL_KV_EMPTY ((uintptr_t)-1)
#define CAL_KV_END	0
#define CAL_KV_minx	1
#define CAL_KV_maxx	2
#define CAL_KV_miny	3
#define CAL_KV_maxy	4

typedef struct _OrientacionInterna{
	KeyVal *info;
	uint flags;
	Lineal2D_dbl afin_1;
	Valores_Interna valI;
	Distorsion distorsion;
} OrientacionInterna;

typedef struct _InternaKPB{
	uint8m inexacta;	//flag. 1: The p.p. had to be displaced by more than 8·10^{-6}*semidag;
						//2: Kappa would need to change by more than 4·10^{-6}. To be ignored if b2 is not going to be written
						//4: The original one had distortions non-repersentable by this model:
						//		DTS and asym. other than c1,c2, d1,d2, c5-d6, c6+d5
						//		Also set if either of k[0],b1,b2 is present here and is not written to the file (depends on the file format).
	struct{
		double cx, cy;	//center, in pixels with respect to top left corner
		double px, py;	//double for formats that make an inadequate use of this parameter
	} pixels;
	double x,y;
	double f;
	float k[5];		//k[0]: distorsión lineal. Made zero in the first instance (for the DRS).
	float p1,p2;		//Half of these could go away
	float b1,b2;		//The appearance of b1 changes k[0]. Hence k[0] and b1 are either both zero or both not zero; b2 would change kappa.
} InternaKPB;

/*Las flags +1 y +2 de inexacta no indican una pérdida de parámetros de distorsión sino que las orientaciones externas obtenidas
aplicando la estructura OrientacionInterna de origen y aplicando la estructura InternaKPB a la que se ha transformado serán distintas.
*/

#define setup_interna(interna) \
	do{\
	(interna)->info=NULL; (interna)->flags=0;\
	zeroset_uint(&(interna)->distorsion,uintsizeof(Distorsion));\
	if(0!=(uintptr_t)NULL){\
		(interna)->distorsion.valores_radsim=NULL;\
		(interna)->distorsion.valores_tansim=NULL;\
		(interna)->distorsion.valores_asim1=NULL;\
		(interna)->distorsion.valores_asim2=NULL;\
	}\
	}while(0)
